import express from "express"
import cors from "cors"
import cookieParser from "cookie-parser"

import googleRoutes from "./routes/google.routes.js"
import { errorHandler } from "./middlewares/errorHandler.js"
import { requestLogger } from "./middlewares/logger.middleware.js"
const app = express()

app.set("trust proxy", true); 

app.use(cors({
    origin: process.env.CORS_ORIGIN|| '*', // Allow all origins or specify your frontend URL
    credentials: true,
    exposedHeaders: ["verificationtoken", "accessToken", "refreshToken"], // Expose custom header
    allowedHeaders: ["Content-Type", "Authorization", "verificationtoken", "accessToken", "refreshToken"],
    methods: ['GET', 'POST', 'PUT', 'DELETE', 'OPTIONS'],
}))

app.use(express.json({limit: "16kb"}))
app.use(express.urlencoded({extended: true, limit: "16kb"}))
app.use(express.static("public"))
app.use(cookieParser())

app.use(requestLogger);

import userRouter from './controllers/users/user.routes.js'

app.use("/api/v1", userRouter)

app.use("/api/v1/auth", googleRoutes); 

app.use(errorHandler);


export { app }