import { Router } from "express";
import { 
    loginUser, 
    logoutUser, 
    resendOTP,
    verifyOTP,
    registerUser, 
    refreshAccessToken, 
    // changeCurrentPassword, 
    getCurrentUser,  
    // updateAccountDetails
} from "../../controllers/users/user.controller.js";
import { verifyJWT } from "../../middlewares/auth.middleware.js";

const router = Router();

router.route("/register").post(registerUser)
// router.route("/google-register").post(googleRegisterUser)
router.route("/login").post(loginUser);
router.route("/resendOTP").get(resendOTP)
router.route('/verify-otp').post(verifyOTP);
router.route("/logout").post(logoutUser)
router.route("/refresh-token").post(refreshAccessToken)
// router.route("/change-password").post(verifyJWT, changeCurrentPassword)
router.route("/current-user").get(verifyJWT, getCurrentUser)
// router.route("/update-account").patch(verifyJWT, updateAccountDetails)

export default router