import { createTransport } from 'nodemailer';

export async function sendOTP(email, otp) {
  const transporter = createTransport({
    host: 'smtp.gmail.com',       // SMTP host
    port: 587,                    // TLS port
    secure: false,                // true for port 465, false for 587
    auth: {
      user: process.env.EMAIL_FROM,       // Gmail address
      pass: process.env.EMAIL_PASSWORD,   // Gmail app password
    },
  });

  const mailOptions = {
    from: process.env.EMAIL_FROM,
    to: email,
    subject: 'Your OTP Code',
    text: `Your OTP code is ${otp}. It is valid for 10 minutes.`,
  };

  transporter.sendMail(mailOptions, (err, info) => {
    if (err) {
      console.error("❌ Failed to send OTP email:", err);
    } else {
      console.log("✅ OTP email sent:", info.response);
    }
  });
}
